<?php
    require __DIR__ . '/vendor/autoload.php';
    use Google\Spreadsheet\DefaultServiceRequest;
    use Google\Spreadsheet\ServiceRequestFactory;

    putenv('GOOGLE_APPLICATION_CREDENTIALS=' . __DIR__ . '/credentials.json');

    $client = new Google_Client;
    $client->useApplicationDefaultCredentials();
    $client->setApplicationName("My App");
    $client->setScopes(['https://www.googleapis.com/auth/drive','https://spreadsheets.google.com/feeds']);
    if ($client->isAccessTokenExpired()) {
        $client->refreshTokenWithAssertion();
    }
    $accessToken = $client->fetchAccessTokenWithAssertion()["access_token"];
    ServiceRequestFactory::setInstance(
        new DefaultServiceRequest($accessToken)
    );
    $service = new Google_Service_Sheets($client);
    $sheet_id = "1TTJYix-fusY9MxXlhr2VRrLC-GJw0oPCFZDRx5GW0XM";
	
	///////////////////////////////////////////
	/* START: Get Value */
	/* $range = "A1:C4";
	$response = $service->spreadsheets_values->get(
      $sheet_id, $range
    );
	$results =  $response->getValues();
	
    echo '<pre>';
    print_r($results); */
	/* END: Get Value */
	
	////////////////////////////////////////////
	/* START: Update value */
	/* $range = "A1:B1";
	$myValue = [
				  ["Sanjeev1","Kumar1"]
			   ];
	$updateBody = new Google_Service_Sheets_ValueRange([
        'values' => $myValue
    ]);
	$params = ['valueInputOption' => "RAW"];
	
	$service->spreadsheets_values->update(
        $sheet_id,
        $range,
        $updateBody,
        $params
    ); */
	/* END: Update value */
	///////////////////////////////////////
	
	/* START: Inser new row */
	$range = "A1:N5000";//"A6:C6";
	
	$name   = $_POST['name'];
	$number = $_POST['number'];
	
	$value = array(
		array("$name","$number")
	);		 
	$body = new Google_Service_Sheets_ValueRange([
        'values' => $value
    ]);
	$params = [
		'valueInputOption' => "RAW"
	];
	$insert = ['valueDataOption' => "INSERT_ROWS"];
	$results1 = $service->spreadsheets_values->append(
		$sheet_id,
		$range,
		$body,
		$params,
		$insert
	);
	printf("%d cells appended.", $results1->getUpdates()->getUpdatedCells());		
	/* echo '<pre>';
    print_r($results1); */ 
	/* END: Update value */
?>
<form name="form" method="post" action="">
	
	<tr>
		<td><strong>Name:</strong></td>
		<td><input type="text" name="name" style="width: 90%;" /></td>
	</tr>
	
	<tr>
		<td><strong>Mobile Number:</strong></td>
		<td><input type="text" name="number" style="width: 90%;" /></td>
	</tr>
	<tr>
		<td><input type="submit" name="submit" value="Submit" /></td>
	</tr>
</form>