<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_FirebaseManagement_FirebaseProject extends Google_Model
{
  public $displayName;
  public $name;
  public $projectId;
  public $projectNumber;
  protected $resourcesType = 'Google_Service_FirebaseManagement_DefaultResources';
  protected $resourcesDataType = '';

  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  public function getDisplayName()
  {
    return $this->displayName;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  public function setProjectId($projectId)
  {
    $this->projectId = $projectId;
  }
  public function getProjectId()
  {
    return $this->projectId;
  }
  public function setProjectNumber($projectNumber)
  {
    $this->projectNumber = $projectNumber;
  }
  public function getProjectNumber()
  {
    return $this->projectNumber;
  }
  /**
   * @param Google_Service_FirebaseManagement_DefaultResources
   */
  public function setResources(Google_Service_FirebaseManagement_DefaultResources $resources)
  {
    $this->resources = $resources;
  }
  /**
   * @return Google_Service_FirebaseManagement_DefaultResources
   */
  public function getResources()
  {
    return $this->resources;
  }
}
